unit AdminDB;

interface
  uses
    SysUtils,
	  System.Data,
  	Borland.Data.Provider, Borland.Data.Common;

type

  TAdminDetails = class
  private
    { Private Declarations }
  public
		FullName : String;
		Email : String;
		Password :String;

    constructor Create;
  end;

  TAdminDB = class
  private
    { Private Declarations }
  public
    constructor Create;

    function GetAdminDetails(const adminID:string) : TAdminDetails;
  	function AddAdmin(fullName, email, password : String) : boolean;
		function Login(email, password : String) : String;
  end;




implementation

uses Helper;

{ TAdminDB }

function TAdminDB.AddAdmin(fullName, email, password: String) : boolean;
const
  AdminValue = 1;
var
  myConnection : BDPConnection;
	myCommand : BDPCommand;
  insertSQL : widestring;
begin
  insertSQL := 'INSERT INTO Customers (FullName, EmailAddress, Pass, IsAdmin) VALUES ('+ QuotedStr(fullName) +', '+ QuotedStr(email) +', '+ QuotedStr(password) +', '+ Convert.ToString(AdminValue) +')';

	// Create Instance of Connection and Command Object
	myConnection := BDPConnection.Create(THelper.ConnectionString);
  myConnection.ConnectionOptions := THelper.ConnectionOptions;
	myCommand := BDPCommand.Create(insertSQL, myConnection);

	try
    myConnection.Open;
		myCommand.ExecuteNonQuery;
		myConnection.Close;

    Result := True;
	except
    Result := False;
	end;

end;

constructor TAdminDB.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
end;

function TAdminDB.GetAdminDetails(const adminID: string): TAdminDetails;
var
	myConnection : BDPConnection;
	myCommand : BDPCommand;
	parameterCustomerID,
	parameterFullName,
	parameterEmail,
	parameterPassword : BDPParameter;
	myAdminDetails : TAdminDetails;
begin
	// Create Instance of Connection and Command Object
	myConnection := BDPConnection.Create(THelper.ConnectionString);
  myConnection.ConnectionOptions := THelper.ConnectionOptions;
	myCommand := BDPCommand.create('CustomerDetail', myConnection);

	// Mark the Command as a SPROC
	myCommand.CommandType := CommandType.StoredProcedure;

	// Add Parameters to SPROC
	parameterCustomerID := BDPParameter.create('CustomerID', BDPType.Int32, 4);
	parameterCustomerID.Value := TObject(adminID);
	myCommand.Parameters.Add(parameterCustomerID);

	parameterFullName := BDPParameter.create('FullName', BDPType.String, 50);
	parameterFullName.Direction := ParameterDirection.Output;
  parameterFullName.Precision := 50;
	myCommand.Parameters.Add(parameterFullName);

	parameterEmail := BDPParameter.create('Email', BDPType.String, 50);
	parameterEmail.Direction := ParameterDirection.Output;
  parameterEmail.Precision := 50;
	myCommand.Parameters.Add(parameterEmail);

	parameterPassword := BDPParameter.create('Password', BDPType.String, 50);
	parameterPassword.Direction := ParameterDirection.Output;
  parameterPassword.Precision := 50;
	myCommand.Parameters.Add(parameterPassword);

	myConnection.Open;
	myCommand.ExecuteNonQuery;
	myConnection.Close;

	// Create CustomerDetails Struct
	myAdminDetails := TAdminDetails.Create;

	// Populate Struct using Output Params from SPROC
	myAdminDetails.FullName := (parameterFullName.Value.ToString);
	myAdminDetails.Password := (parameterPassword.Value.ToString);
	myAdminDetails.Email := (parameterEmail.Value.ToString);

	Result := myAdminDetails;
end;

{ TAdminDetailsDB }

constructor TAdminDetails.Create;
begin
  inherited Create;

end;

function TAdminDB.Login(email, password: String): String;
const
  AdminValue = 1;
var
	myConnection : BDPConnection;
	myCommand : BDPCommand;
  s : string;
  ret : TObject;
begin
  s := 'SELECT CustomerID FROM Customers WHERE IsAdmin = ' + Convert.ToString(AdminValue) + ' AND EmailAddress = ' + QuotedStr(email) + ' AND Pass =' + QuotedStr(password);

	myConnection := BDPConnection.Create(THelper.ConnectionString);
  myConnection.ConnectionOptions:=THelper.ConnectionOptions;
	myCommand := BDPCommand.create(s, myConnection);


  myConnection.Open;
  ret := MyCommand.ExecuteScalar;
  myConnection.Close;

  if (NOT Assigned(ret)) OR (Integer(ret) = 0) then
    Result := EmptyStr
  else
    Result := ret.ToString;


end;

end.
